<?php
/* --------------------------------------------------------------
   GambioHubPayPalController.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioHubPayPalController extends GambioHubPayPalController_parent
{
    /**
     * returns content for installments options popup
     */
    public function actionInstallmentOptions()
    {
        if(strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) !== 'true') {
            return parent::actionInstallmentOptions();
        }
        
        $amount                        = (double)$this->_getPostData('amount');
        $paypalInstallments            = MainFactory::create('PayPalInstallments');
        try
        {
            $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
            $response = $paypalInstallments->getInstallmentInfo(
                $amount,
                $_SESSION['currency'],
                'DE'
            );
            $creditOptions = array_merge($response->financing_options[0]->qualifying_financing_options);
            $representativeOption = $paypalInstallments->getRepresentativeOption($creditOptions);
            $tplPresentationVersion = $GLOBALS['coo_template_control']->get_template_presentation_version();
            if ($tplPresentationVersion <= 3) {
                $installmentOptionsContentView = MainFactory::create('ContentView');
                $installmentOptionsContentView->set_content_template('module/paypalinstallmentoptions.html');
            } else {
                $installmentOptionsContentView = MainFactory::create('ThemeContentView');
                $installmentOptionsContentView->set_content_template('paypal_installment_options.html');
            }
            $installmentOptionsContentView->set_flat_assigns(true);
            $installmentOptionsContentView->set_caching_enabled(false);
            $installmentOptionsContentView->set_content_data('amount_too_high',             $amount > 5000);
            $lender = null;
            if ($hubPayPalConfiguration->isInstallmentsActive()) {
                $lender = $hubPayPalConfiguration->getIUPLender();
            }
            if ($lender === null || $hubPayPalConfiguration->isInstallmentsActive() !== true) {
                $lender = implode(
                    ', ',
                    [
                        COMPANY_NAME,
                        TRADER_STREET . ' ' . TRADER_STREET_NUMBER,
                        TRADER_ZIPCODE . ' ' . TRADER_LOCATION,
                    ]
                );
            }
            $installmentOptionsContentView->set_content_data('lender',                      $lender);
            $installmentOptionsContentView->set_content_data('cashPurchasePrice',           sprintf('%s&nbsp;%s', number_format($amount, 2, ',', ''), $_SESSION['currency']));
            $installmentOptionsContentView->set_content_data('currency',                    $_SESSION['currency']);
            $installmentOptionsContentView->set_content_data('qualifyingOptions',           $response->financing_options[0]->qualifying_financing_options);
            $installmentOptionsContentView->set_content_data('representativeFinancingCode', $representativeOption->credit_financing->financing_code);
            $content = $installmentOptionsContentView->get_html();
        }
        catch(Exception $e)
        {
            $content = '<div class="pp_cs_popup_inner"><button title="Close" type="button" class="mfp-close">×</button>';
            $content .= $this->paypalText->get_text('error_retrieving_installments_info');
            $content .= '</div>';
        }
        return MainFactory::create('HttpControllerResponse', $content);
    }
}
